/*
 * Decompiled with CFR 0.152.
 */
package br.com.embraer.massif.commandevaluation.util;

import br.com.embraer.massif.commandevaluation.exception.MatlabError;
import br.com.embraer.massif.commandevaluation.exception.MatlabPropertiesException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class MatlabProviderProperties {
    public static final String MATLAB_SERVER_DEFAULT_SERVICE_NAME = "MatlabModelProvider";
    public static final String MATLAB_SERVER_ADDRESS = "serveraddress";
    public static final String MATLAB_SERVER_PORT = "serverport";
    public static final String MATLAB_SERVER_SERVICE_NAME = "serverservice";
    public static final String MATLAB_SERVER_DEBUG_MODE = "debug";
    public static final String MATLAB_DEFAULT_CONFIG_FILE_NAME = "matlabserverconfig.properties";
    private Properties properties;
    private String configPath;

    public MatlabProviderProperties() throws MatlabPropertiesException {
        this.loadPropertiesFile(MATLAB_DEFAULT_CONFIG_FILE_NAME);
    }

    public MatlabProviderProperties(String configPath) throws MatlabPropertiesException {
        this.loadPropertiesFile(configPath);
    }

    private void loadPropertiesFile(String configPath) throws MatlabPropertiesException {
        this.configPath = configPath;
        this.properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(configPath);
                this.properties.load(fileInputStream);
            }
            catch (IOException ex) {
                MatlabPropertiesException exception = new MatlabPropertiesException(MatlabError.READ_PROPERTIES_FILE_ERROR, (Throwable)ex);
                exception.set("File path", configPath);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Should never happen!");
                }
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Should never happen!");
            }
        }
    }

    public String getProperty(String key) throws MatlabPropertiesException {
        String property = null;
        if (this.properties == null) {
            MatlabPropertiesException exception = new MatlabPropertiesException(MatlabError.PROPERTY_NOT_EXIST_ERROR, null);
            exception.set("File path", this.configPath);
            exception.set("Property", key);
            throw exception;
        }
        property = this.properties.getProperty(key);
        return property;
    }

    public String getConfigPath() {
        return this.configPath;
    }
}

